//
//  EscalationDetails.swift
//  Orbis
//
//  Created by KALSI on 7/7/17.
//  Copyright © 2017 KALSI. All rights reserved.
//

import UIKit
import IQKeyboardManagerSwift

struct My {
    static var cellSnapshot : UIView? = nil
}
struct Path {
    static var initialIndexPath : NSIndexPath? = nil
}

class EscalationDetails: UIViewController ,UITableViewDataSource, UITableViewDelegate{
    @IBOutlet weak var escalationTableView: UITableView!
    
//    let numbers = [ProfileInfoModel.sharedInstance.phone_number1,ProfileInfoModel.sharedInstance.phone_number2,ProfileInfoModel.sharedInstance.phone_number3]
//    let names = [ProfileInfoModel.sharedInstance.name1,ProfileInfoModel.sharedInstance.name2,ProfileInfoModel.sharedInstance.name3]
//
//
    var numbers = ["123456789","213456789","321456789"]
    var names = ["John Doe","Jack Singh","Shaun Wilcock"]
    var tempTxfld = UITextField()
    
    
    // MARK: -
    override func viewDidLoad() {
        super.viewDidLoad()
        IQKeyboardManager.sharedManager().enableAutoToolbar = true
        escalationTableView.tableFooterView = UIView()
    
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
    // MARK: -

    @IBAction func GoBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    func snapshopOfCell(inputView: UIView) -> UIView {
        UIGraphicsBeginImageContextWithOptions(inputView.bounds.size, false, 0.0)
        inputView.layer.render(in: UIGraphicsGetCurrentContext()!)
        let image = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        let cellSnapshot : UIView = UIImageView(image: image)
        cellSnapshot.layer.masksToBounds = false
        cellSnapshot.layer.cornerRadius = 0.0
        cellSnapshot.layer.shadowOffset = CGSize(width : -5.0, height : 0.0)
        cellSnapshot.layer.shadowRadius = 5.0
        cellSnapshot.layer.shadowOpacity = 0.4
        return cellSnapshot
    }
    @IBAction func tableviewLongPress(_ sender: UILongPressGestureRecognizer) {
        let longPress = sender as UILongPressGestureRecognizer
        let state = longPress.state
        let locationInView = longPress.location(in: escalationTableView)
        let indexPath = escalationTableView.indexPathForRow(at: locationInView)
        
      
        
        switch state {
            
    
        case .began:
            if indexPath != nil {
                Path.initialIndexPath = indexPath! as NSIndexPath
                let cell = escalationTableView.cellForRow(at: indexPath!) as! CustomEscalationCell!
                My.cellSnapshot  = snapshopOfCell(inputView: cell!)
                My.cellSnapshot?.layer.cornerRadius = 10
                My.cellSnapshot?.layer.masksToBounds = true
                var center = cell?.center
                My.cellSnapshot!.center = center!
                My.cellSnapshot!.alpha = 0.0
                escalationTableView.addSubview(My.cellSnapshot!)
                
                UIView.animate(withDuration: 0.30, animations: { () -> Void in
                    center?.y = locationInView.y
                    My.cellSnapshot!.center = center!
                    My.cellSnapshot!.transform = CGAffineTransform(rotationAngle: -150.9)//CGAffineTransform(scaleX: 0.98, y: 1.05)
                    My.cellSnapshot!.alpha = 0.98
                    cell?.alpha = 0.0
                    
                }, completion: { (finished) -> Void in
                    if finished {
                        cell?.isHidden = true
                    }
                })
            }
    
       
        case .possible:
            break
        case .changed:
            var center = My.cellSnapshot!.center
            center.y = locationInView.y
            My.cellSnapshot!.center = center
            if ((indexPath != nil) && (indexPath != Path.initialIndexPath as IndexPath?)) {
                swap(&names[indexPath!.row], &names[Path.initialIndexPath!.row])
                swap(&numbers[indexPath!.row], &numbers[Path.initialIndexPath!.row])

                escalationTableView.moveRow(at: Path.initialIndexPath! as IndexPath, to: indexPath!)
                Path.initialIndexPath = indexPath! as NSIndexPath
            }
            break
        case .ended:
            My.cellSnapshot?.removeFromSuperview()
            escalationTableView.reloadData()

            break
        case .cancelled:
            break
        case .failed:
            break
        }
    }
    
       
    //MARK:- UITableViewDelegate -
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat{
        return 70
    }
//    func numberOfSections(in tableView: UITableView) -> Int{
//        return 3
//
//    }
//
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 3
    }
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        if tableView.tag == 101 {
            let cell = tableView.dequeueReusableCell(withIdentifier: "labelCell")!
            tableView.separatorStyle = .none
            cell.selectionStyle = .none
            cell.textLabel?.text = "\(indexPath.row + 1) ∣"//
            cell.textLabel?.textAlignment = .left
            return cell

        }else {
        let cell = tableView.dequeueReusableCell(withIdentifier: "customcell")! as! CustomEscalationCell
        tableView.separatorStyle = .none
        cell.selectionStyle = .none
        cell.Name.text = names[indexPath.row]
        cell.number.text = numbers[indexPath.row]

        cell.bgView.layer.cornerRadius = 10
        cell.bgView.layer.masksToBounds = true
            cell.editButton.tag = indexPath.row
            cell.editButton.addTarget(self, action: #selector(editEscalationDetails(sender:)), for: .touchUpInside)

        return cell
        }
    }


    func editEscalationDetails(sender : UIButton)  {
        
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "EditEscalationDetails") as! EditEscalationDetails
        self.navigationController?.pushViewController(vc, animated: true)


        
    }
   
    
}
